
#ifndef _GETN_GRAPH_DLG_H_
#define _GETN_GRAPH_DLG_H_




class GetNGraphSplitter : public TreeEditSplitter
{
public:
	GetNGraphSplitter();
	
	void InitTree(TreeNode& tr, PGRAPH_FUNC pfnView, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions);
	void SetTree(TreeNode& tr, bool bUpdateGUI=false);
	void GetTree(TreeNode& tr);
	
	int GetGraphPaneID() { return GetMainPaneID(); }
	void CreatePreviewGraph(GraphControl& gcCntrl);
	
	bool IsPreviewGraphUsed();
	
	BOOL OnSelectionChange();
	BOOL OnSelectionTrack();
	
	bool IsImageMode();// { return (m_dwOptions & GETNG_IMAGE_PANE)? true:false;}	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitSplitter) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	
	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_USER_MSG(WM_USER_GETNGRAPH_CHANGED_BY_GRAPH, OnChangeByGraph)
	
	ON_BN_CLICKED(IDC_DATARANGE_DLG_BUTTON, OnInteractiveDataRange)
	ON_BN_CLICKED(IDC_XY_DATARANGE_DLG_BUTTON, OnInteractiveXYDataRange)
	ON_BN_CLICKED(IDC_INTERACTIVE_POPUP_BTN,  OnInteractivePopUp)

	ON_USER_MSG(WM_USER_ON_TRACK, OnTrackSlider) //---- CPY 9/12/05 GET_N_IMAGE_DIALOG

EVENTS_END
	BOOL OnInteractiveDataRange(Control ctrl);
	BOOL OnInteractiveXYDataRange(Control ctrl);
	BOOL OnInteractivePopUp(Control ctrl);

	BOOL OnInitSplitter();
	BOOL OnResize(int nType, int cx, int cy);
	
	void OnAfterValueChange(int nRow, int nCol);
	void OnChangeByGraph(DWORD wParam, DWORD lParam);
	
	BOOL OnTrackSlider(uint wParam, uint lParam); //---- CPY 9/12/05 GET_N_IMAGE_DIALOG

private:
	void createGraph(GraphControl& gcCntrl, GraphPageControl& graphCtrl, LPCSTR lpcszTemplate=NULL, LPCSTR lpcszWksName=NULL);
	
	PEVENT_FUNC getEventHandler();
	PGRAPH_FUNC getGraphHandler();
	PIMAGE_FUNC getImageHandler() { return m_pImageFunc; } 
	
	void initAllEvents();
	void invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo);//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	
private:
	PEVENT_FUNC 				m_pEventFunc;
	PGRAPH_FUNC 				m_pGraphFunc;
	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	PIMAGE_FUNC					m_pImageFunc;
	ImageControlBase			*m_pimgView;	
	DWORD						m_dwOptions;
	//------
	GraphPageControl			m_gpView;
	GraphPageControl			m_gpPreview;
	
	bool						m_bShowViewGraph;
	bool						m_bIsReady;
	
//----- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
//	bool						m_bShowPreviewGraph;
	int		m_nGetNDlgType;
};

#define STR_DLG_NAME 					"GetNGraphDlg"

//---- CPY 9/12/05 GET_N_IMAGE_DIALOG
//enum {
//	GETNG_IMAGE_PANE = 1,
//};
//-----
class GetNGraphDlg : public MultiPaneDlg
{
public:
	//GetNGraphDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, PEVENT_FUNC pEvtFn, bool bTreeEditRightPane) : MultiPaneDlg(IDD_GETNBOX_PREVIEW, "ODlg")
	//{
		//m_input_tr = tr;
		//
		//m_strTitle = lpcszTitle;
		//m_strDescription = lpcszDescription;
		//
		//m_splitter.InitTree(m_input_tr, pfn, pEvtFn);
		//
		////s_bTreeEditRightPane = bTreeEditRightPane;
	//}
	GetNGraphDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, PIMAGE_FUNC pfnImg = NULL, int nEventID = XF_GETN_GRAPH_OLD, DWORD dwOptions = 0);
	~GetNGraphDlg();
	
	int DoModalEx(HWND hWndParent)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		//--- CPY QA70-8122 GETN_IMAGE_DLG_NEED_REPOSITION_BETWEEN_SESSION
		//if(hWndParent)
		//	dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
		//---
		int nRet = DoModal(hWndParent, dwDlgOptions);
		if(IDOK == nRet)
		{
			 m_splitter.GetTree(m_input_tr);
		}
		return nRet;
	}
	void UpdateEditTreeNode(TreeNode& tr)
	{
		tr = m_input_tr;
	}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_HELPINFO(OnHelp)
	
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	
	ON_BN_CLICKED(IDC_PARAMS_MORE, OnShowPreview)
	
	ON_CBN_SELCHANGE(IDC_GETN_THEME_COMB, OnComboChangeTheme)
	ON_BN_CLICKED(IDC_GETN_SAVE_BTN, OnSaveTheme)
	ON_BN_CLICKED(IDC_GETN_SAVE_AS_BTN, OnSaveThemeAs)
	
	///DG 7/27/05 : for changing the input data
	ON_CHANGE_SELECTION(OnSelectionChange)
	ON_SELECTION_TRACK(OnSelectionTrack)
	///end
	

EVENTS_END

	/// YuI 09/29/05 MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL
	BOOL OnDestroy();
	/// end MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL OnClickOK();
	BOOL OnClickCancel();
	
	BOOL OnShowPreview(Control ctrl);
	
	BOOL OnComboChangeTheme(Control ctrl);
	BOOL OnSaveTheme(Control ctrl);
	BOOL OnSaveThemeAs(Control ctrl);
	
	BOOL OnSelectionChange();
	BOOL OnSelectionTrack();


protected:
	void SetDialogTitle(LPCSTR lpcszTitle);
	
private:
	void resizeTopPaneControl(int cx, int cy);
	void replaceLabelSizeForSplitter();
	
	void loadThemeFilesToCombo(TreeNode& trGUI);
	bool saveAsTheme(LPCSTR lpcszThemeFilename);
	void updateSaveButton(const string& strSelTheme);
	
private:
	TreeNode				m_input_tr;
	string					m_strTitle;
	string					m_strDescription;
	
	GetNGraphSplitter		m_splitter;
	
	vector<uint>			m_vnThemeSaveGroup;
	ComboBox				m_comboTheme;
	Control					m_btnSaveTheme;
	Control					m_txtStatus;
	
	Control					m_ctrlLabel;

};


#endif //_GETN_GRAPH_DLG_H_